/*
 * Decompiled with CFR 0.152.
 */
package chanceCubes.rewards.defaultRewards;

import chanceCubes.rewards.defaultRewards.BaseCustomReward;
import chanceCubes.util.CCubesDamageSource;
import chanceCubes.util.CustomEntry;
import chanceCubes.util.GuiTextLocation;
import chanceCubes.util.RewardsUtil;
import chanceCubes.util.Scheduler;
import chanceCubes.util.Task;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class QuestionsReward
extends BaseCustomReward {
    private final Map<Player, String> inQuestion = new HashMap<Player, String>();
    private final List<CustomEntry<String, String>> questionsAndAnswers = new ArrayList<CustomEntry<String, String>>();

    public QuestionsReward() {
        super("chancecubes:question", -30);
        this.addQuestionAnswer("What is the username of the creator of Chance Cubes?", "Turkey -or- Turkey2349 -or- TurkeyDev");
        this.addQuestionAnswer("How many sides does the sparkly, shiny, colorful, spinny Chance Cube have?", "20");
        this.addQuestionAnswer("What is 9 + 10", "19 -or- 21");
        this.addQuestionAnswer("What year was minecraft officially released", "2011");
        this.addQuestionAnswer("What company developes Java?", "Sun -or- Sun Microsystems -or- Oracle");
        this.addQuestionAnswer("Who created Minecraft?", "Notch");
    }

    public void addQuestionAnswer(String q, String a) {
        this.questionsAndAnswers.add(new CustomEntry<String, String>(q, a));
    }

    @Override
    public void trigger(ServerLevel level, BlockPos pos, final Player player, JsonObject settings) {
        if (this.inQuestion.containsKey(player)) {
            return;
        }
        if (!RewardsUtil.isPlayerOnline(player)) {
            return;
        }
        int question = RewardsUtil.rand.nextInt(this.questionsAndAnswers.size());
        RewardsUtil.sendMessageToPlayer(player, this.questionsAndAnswers.get(question).getKey());
        RewardsUtil.sendMessageToPlayer(player, "You have 20 seconds to answer! (Answer is not case sensitive)");
        this.inQuestion.put(player, this.questionsAndAnswers.get(question).getValue());
        Scheduler.scheduleTask(new Task("Question", 400, 20){

            @Override
            public void callback() {
                QuestionsReward.this.timeUp(player, false);
            }

            @Override
            public void update() {
                if (!QuestionsReward.this.inQuestion.containsKey(player)) {
                    Scheduler.removeTask(this);
                }
                if (this.delayLeft % 20 == 0) {
                    this.showTimeLeft(player, GuiTextLocation.ACTION_BAR);
                }
            }
        });
    }

    private void timeUp(Player player, boolean correct) {
        if (!this.inQuestion.containsKey(player)) {
            return;
        }
        if (correct) {
            RewardsUtil.sendMessageToPlayer(player, "Correct!");
            RewardsUtil.sendMessageToPlayer(player, "Here, have a item!");
            player.f_19853_.m_7967_((Entity)new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)RewardsUtil.getRandomItem(), 1)));
        } else {
            RewardsUtil.sendMessageToPlayer(player, "Incorrect! The answer was " + this.inQuestion.get(player));
            player.f_19853_.m_46511_((Entity)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, Explosion.BlockInteraction.NONE);
            player.m_6469_((DamageSource)CCubesDamageSource.QUESTION_FAIL, Float.MAX_VALUE);
        }
        this.inQuestion.remove(player);
    }

    @SubscribeEvent
    public void onMessage(ServerChatEvent event) {
        ServerPlayer player = event.getPlayer();
        if (this.inQuestion.containsKey(player)) {
            String answer = event.getMessage();
            boolean correct = false;
            for (String s : this.inQuestion.get(player).split("-or-")) {
                if (!s.trim().equalsIgnoreCase(answer.trim())) continue;
                correct = true;
                break;
            }
            this.timeUp((Player)player, correct);
            event.setCanceled(true);
        }
    }
}

